/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.modlist;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.ControlPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.modlist.DiffEntry;
import dev.kostromdan.mods.crash_assistant.app.gui.modlist.ManualDownloadDialog;
import dev.kostromdan.mods.crash_assistant.app.gui.modlist.SectionPanel;
import dev.kostromdan.mods.crash_assistant.app.utils.ClipboardUtils;
import dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader.ModPlatformLookupService;
import dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader.api.CurseForge;
import dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader.api.Modrinth;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModFingerprinter;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.UpdatedPair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ModListDiffDialog
extends JFrame {
    private static ModListDiffDialog INSTANCE;
    private final Window parentWindow;
    private static final ImageIcon CF_ICON;
    private static final ImageIcon MR_ICON;
    private final List<JButton> footerButtons = new ArrayList<JButton>();
    private final JProgressBar progressBar = new JProgressBar();
    private final JLabel progressLabel = new JLabel(" ");
    private final JPanel progressButtonsPanel = new JPanel(new FlowLayout(0, 6, 0));
    private final JButton cancelCurrentButton = new JButton(LanguageProvider.get((String)"gui.modlist_diff.cancel_current"));
    private final JButton cancelAllButton = new JButton(LanguageProvider.get((String)"gui.modlist_diff.cancel_all"));
    private volatile boolean cancelCurrentRequested = false;
    private volatile boolean cancelAllRequested = false;
    private volatile DiffEntry cancelTargetEntry = null;
    private volatile boolean preferModrinth = false;
    private volatile boolean lookupWarningShown = false;
    private volatile DiffEntry currentActionEntry = null;
    private volatile DiffEntry activeDownloadEntry = null;
    private volatile InputStream activeDownloadStream = null;
    private volatile HttpURLConnection activeDownloadConnection = null;
    private volatile Thread activeActionThread = null;
    private volatile boolean cfReady = false;
    private volatile boolean mrReady = false;
    private final ThreadPoolExecutor actionExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
        Thread t = new Thread(r, "modlist-actions");
        t.setDaemon(true);
        return t;
    });
    private final ExecutorService instantActionExecutor = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "modlist-instant-actions");
        t.setDaemon(true);
        return t;
    });
    private JButton disableToggleButton;
    private final List<DiffEntry> addedEntries = new ArrayList<DiffEntry>();
    private final List<DiffEntry> updatedEntries = new ArrayList<DiffEntry>();
    private final List<DiffEntry> removedEntries = new ArrayList<DiffEntry>();
    private final Map<SectionType, SectionPanel> sectionPanels = new EnumMap<SectionType, SectionPanel>(SectionType.class);
    private ModPlatformLookupService.LookupResult lookupResult;
    private final JLabel statusLabel = new JLabel(" ");
    private final JButton applyButton = new JButton();

    public static void showDialog(Window parent) {
        boolean hasSavedModlist;
        boolean bl = hasSavedModlist = !ModListUtils.getSavedModList().isEmpty();
        if (!CrashAssistantApp.gameLaunchedSuccessfully && !hasSavedModlist) {
            JOptionPane.showMessageDialog(parent, LanguageProvider.get((String)"gui.modlist_diff.first_launch_warning"), LanguageProvider.get((String)"gui.modlist_diff_dialog_name"), 2);
            return;
        }
        LinkedHashSet savedMods = ModListUtils.getSavedModList();
        if (savedMods.size() >= 3) {
            boolean anyHasHash = false;
            for (Mod mod : savedMods) {
                if (mod.getCurseForgeHash() == null && mod.getModrinthHash() == null) continue;
                anyHasHash = true;
                break;
            }
            if (!anyHasHash) {
                JOptionPane.showMessageDialog(parent, LanguageProvider.get((String)"gui.modlist_diff.legacy_warning"), LanguageProvider.get((String)"gui.modlist_diff_dialog_name"), 2);
            }
        }
        if (INSTANCE == null) {
            Window blockParent = CrashAssistantGUI.getFrame();
            if (blockParent == null) {
                blockParent = parent;
            }
            INSTANCE = new ModListDiffDialog(blockParent);
        }
        INSTANCE.setLocationRelativeTo(parent);
        INSTANCE.setVisible(true);
        INSTANCE.toFront();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (this.parentWindow != null) {
                this.parentWindow.setVisible(false);
            }
        } else if (this.parentWindow != null) {
            this.parentWindow.setVisible(true);
            this.parentWindow.toFront();
        }
        super.setVisible(b);
    }

    private ModListDiffDialog(Window parent) {
        super(LanguageProvider.get((String)"gui.modlist_diff_dialog_name"));
        this.parentWindow = parent;
        CrashAssistantGUI.setUpIcon(this);
        this.setDefaultCloseOperation(1);
        ModListDiff diff = ModListDiff.getDiff((boolean)true);
        this.populateEntries(diff);
        this.lookupResult = new ModPlatformLookupService.LookupResult(Collections.emptyMap(), Collections.emptyMap());
        this.buildUi();
        this.startLookupAsync();
        this.pack();
        Dimension packedSize = this.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int targetHeight = (int)((double)screen.height * 0.8);
        int width = packedSize.width;
        if (packedSize.height > targetHeight) {
            width += new JScrollBar((int)1).getPreferredSize().width;
        }
        this.setMinimumSize(new Dimension(width, 300));
        this.setSize(new Dimension(width, targetHeight));
    }

    private void populateEntries(ModListDiff diff) {
        for (Mod added : diff.getAddedMods()) {
            this.addedEntries.add(new DiffEntry(SectionType.ADDED, added, null));
        }
        for (UpdatedPair pair : diff.getUpdatedMods()) {
            this.updatedEntries.add(new DiffEntry(pair));
        }
        for (Mod removed : diff.getRemovedMods()) {
            this.removedEntries.add(new DiffEntry(SectionType.REMOVED, null, removed));
        }
    }

    private Set<Long> collectFingerprints(boolean includeSaved) {
        LinkedHashSet<Long> set = new LinkedHashSet<Long>();
        for (DiffEntry entry : this.allEntries()) {
            set.addAll(entry.getCurseHashes(includeSaved));
        }
        return set;
    }

    private Set<String> collectHashFingerprints(boolean includeSaved) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (DiffEntry entry : this.allEntries()) {
            set.addAll(entry.getModrinthHashes(includeSaved));
        }
        return set;
    }

    private List<DiffEntry> allEntries() {
        ArrayList<DiffEntry> list = new ArrayList<DiffEntry>();
        list.addAll(this.addedEntries);
        list.addAll(this.updatedEntries);
        list.addAll(this.removedEntries);
        return list;
    }

    private void applyLookupResults() {
        for (DiffEntry entry : this.allEntries()) {
            this.applyMatches(entry, this.lookupResult);
        }
    }

    private void startLookupAsync() {
        new Thread(() -> {
            ModPlatformLookupService lookupService = new ModPlatformLookupService();
            Set<Long> cfFingerprints = this.collectFingerprints(true);
            Set<String> mrFingerprints = this.collectHashFingerprints(true);
            JLabel fetchingLabel = new JLabel(LanguageProvider.get((String)"gui.modlist_diff.fetching_warning"));
            fetchingLabel.setForeground(Color.GRAY);
            SwingUtilities.invokeLater(() -> this.statusLabel.setText(fetchingLabel.getText()));
            Runnable cfTask = () -> {
                Map<Long, CurseForge.FingerprintMatch> cfResult = this.lookupCurseForge(lookupService, cfFingerprints);
                SwingUtilities.invokeLater(() -> this.applyLookupUpdate(cfResult, Collections.emptyMap(), true, null));
            };
            Runnable mrTask = () -> {
                Map<String, Modrinth.VersionFileInfo> mrResult = this.lookupModrinth(lookupService, mrFingerprints);
                SwingUtilities.invokeLater(() -> this.applyLookupUpdate(Collections.emptyMap(), mrResult, null, true));
            };
            Thread cfThread = new Thread(cfTask, "modlist-lookup-cf");
            cfThread.setDaemon(true);
            Thread mrThread = new Thread(mrTask, "modlist-lookup-mr");
            mrThread.setDaemon(true);
            cfThread.start();
            mrThread.start();
        }, "modlist-lookup").start();
    }

    private Map<Long, CurseForge.FingerprintMatch> lookupCurseForge(ModPlatformLookupService lookupService, Set<Long> cfFingerprints) {
        Map<Long, CurseForge.FingerprintMatch> cfMap;
        block4: {
            cfMap = null;
            try {
                ModPlatformLookupService.LookupResult cfRes = lookupService.lookup(cfFingerprints, Collections.emptySet());
                cfMap = cfRes != null ? cfRes.getCurseForgeMatches() : null;
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.warn("CurseForge lookup failed", (Throwable)e);
                if (!this.isConnectionIssue(e)) break block4;
                try {
                    ModPlatformLookupService.LookupResult cfRes = lookupService.lookup(cfFingerprints, Collections.emptySet());
                    cfMap = cfRes != null ? cfRes.getCurseForgeMatches() : null;
                }
                catch (Exception ex) {
                    CrashAssistantApp.LOGGER.warn("CurseForge retry failed", (Throwable)ex);
                }
            }
        }
        return cfMap == null ? Collections.emptyMap() : cfMap;
    }

    private Map<String, Modrinth.VersionFileInfo> lookupModrinth(ModPlatformLookupService lookupService, Set<String> mrFingerprints) {
        Map<String, Modrinth.VersionFileInfo> mrMap;
        block4: {
            mrMap = null;
            try {
                ModPlatformLookupService.LookupResult mrRes = lookupService.lookup(Collections.emptySet(), mrFingerprints);
                mrMap = mrRes != null ? mrRes.getModrinthMatches() : null;
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.warn("Modrinth lookup failed", (Throwable)e);
                if (!this.isConnectionIssue(e)) break block4;
                try {
                    ModPlatformLookupService.LookupResult mrRes = lookupService.lookup(Collections.emptySet(), mrFingerprints);
                    mrMap = mrRes != null ? mrRes.getModrinthMatches() : null;
                }
                catch (Exception ex) {
                    CrashAssistantApp.LOGGER.warn("Modrinth retry failed", (Throwable)ex);
                }
            }
        }
        return mrMap == null ? Collections.emptyMap() : mrMap;
    }

    private void applyLookupUpdate(Map<Long, CurseForge.FingerprintMatch> cfMap, Map<String, Modrinth.VersionFileInfo> mrMap, Boolean cfDone, Boolean mrDone) {
        HashMap<Long, CurseForge.FingerprintMatch> newCf = new HashMap<Long, CurseForge.FingerprintMatch>(this.lookupResult.getCurseForgeMatches());
        HashMap<String, Modrinth.VersionFileInfo> newMr = new HashMap<String, Modrinth.VersionFileInfo>(this.lookupResult.getModrinthMatches());
        if (cfMap != null) {
            newCf.putAll(cfMap);
        }
        if (mrMap != null) {
            newMr.putAll(mrMap);
        }
        this.lookupResult = new ModPlatformLookupService.LookupResult(newCf, newMr);
        this.applyLookupResults(this.lookupResult);
        if (cfDone != null) {
            this.cfReady = cfDone;
        }
        if (mrDone != null) {
            this.mrReady = mrDone;
        }
        this.refreshTables();
        this.updateStatusLabel();
    }

    private void applyLookupResults(ModPlatformLookupService.LookupResult res) {
        for (DiffEntry entry : this.allEntries()) {
            this.applyMatches(entry, res);
        }
    }

    private void applyMatches(DiffEntry entry, ModPlatformLookupService.LookupResult res) {
        if (res == null) {
            return;
        }
        for (DiffEntry.ModInstance mi : entry.currentMods) {
            if (mi.curseHash != null) {
                mi.curseMatch = res.getCurseForgeMatches().get(mi.curseHash);
            }
            if (mi.modrinthHash == null) continue;
            mi.modrinthMatch = res.getModrinthMatches().get(mi.modrinthHash);
        }
        for (DiffEntry.ModInstance mi : entry.savedMods) {
            if (mi.curseHash != null) {
                mi.curseMatch = res.getCurseForgeMatches().get(mi.curseHash);
            }
            if (mi.modrinthHash == null) continue;
            mi.modrinthMatch = res.getModrinthMatches().get(mi.modrinthHash);
        }
    }

    private void buildUi() {
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel(new BorderLayout());
        header.setBorder(new EmptyBorder(12, 12, 10, 12));
        JLabel title = new JLabel(ModListDiff.getFirstString((boolean)false, (boolean)false, null));
        title.setFont(title.getFont().deriveFont(1, 16.0f));
        header.add((Component)title, "West");
        this.add((Component)header, "North");
        JPanel sectionsContainer = new JPanel();
        sectionsContainer.setLayout(new BoxLayout(sectionsContainer, 1));
        sectionsContainer.setAlignmentX(0.0f);
        sectionsContainer.setAlignmentY(0.0f);
        SectionPanel addedPanel = new SectionPanel(this, SectionType.ADDED, this.addedEntries);
        sectionsContainer.add(this.wrapTop(addedPanel.getComponent()));
        sectionsContainer.add(Box.createVerticalStrut(4));
        SectionPanel updatedPanel = new SectionPanel(this, SectionType.UPDATED, this.updatedEntries);
        sectionsContainer.add(this.wrapTop(updatedPanel.getComponent()));
        sectionsContainer.add(Box.createVerticalStrut(4));
        SectionPanel removedPanel = new SectionPanel(this, SectionType.REMOVED, this.removedEntries);
        sectionsContainer.add(this.wrapTop(removedPanel.getComponent()));
        sectionsContainer.add(Box.createVerticalGlue());
        this.sectionPanels.put(SectionType.ADDED, addedPanel);
        this.sectionPanels.put(SectionType.UPDATED, updatedPanel);
        this.sectionPanels.put(SectionType.REMOVED, removedPanel);
        JScrollPane scrollPane = new JScrollPane(sectionsContainer);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getViewport().setAlignmentY(0.0f);
        scrollPane.getViewport().setAlignmentX(0.0f);
        this.add((Component)scrollPane, "Center");
        JPanel footer = new JPanel(new BorderLayout());
        footer.setBorder(new EmptyBorder(10, 12, 10, 12));
        this.statusLabel.setForeground(new Color(70, 70, 70));
        footer.add((Component)this.statusLabel, "West");
        JPanel buttons = new JPanel(new FlowLayout(2));
        JButton copyDiff = new JButton(LanguageProvider.get((String)"gui.modlist_diff.copy_diff"));
        copyDiff.addActionListener(e -> this.copyDiffWithFeedback(copyDiff));
        buttons.add(copyDiff);
        this.footerButtons.add(copyDiff);
        this.disableToggleButton = new JButton(LanguageProvider.get((String)"gui.files_remover.disable_selected"));
        this.disableToggleButton.addActionListener(e -> {
            if (this.allSelectedDisabled()) {
                this.bulkApply(SectionAction.ENABLE);
            } else {
                this.bulkApply(SectionAction.DISABLE);
            }
        });
        buttons.add(this.disableToggleButton);
        this.footerButtons.add(this.disableToggleButton);
        JButton removeSelected = new JButton(LanguageProvider.get((String)"gui.files_remover.remove_selected"));
        removeSelected.addActionListener(e -> this.bulkApply(SectionAction.REMOVE));
        buttons.add(removeSelected);
        this.footerButtons.add(removeSelected);
        this.updateApplyButtonLabel();
        buttons.add(this.applyButton);
        this.footerButtons.add(this.applyButton);
        footer.add((Component)buttons, "East");
        JPanel progressRow = new JPanel(new BorderLayout(6, 0));
        this.progressBar.setPreferredSize(new Dimension(180, 16));
        this.progressBar.setVisible(false);
        progressRow.add((Component)this.progressLabel, "West");
        progressRow.add((Component)this.progressBar, "Center");
        this.cancelCurrentButton.addActionListener(e -> this.requestCancelCurrentOperation());
        this.cancelAllButton.addActionListener(e -> this.requestCancelAllOperations());
        this.progressButtonsPanel.add(this.cancelCurrentButton);
        this.progressButtonsPanel.add(this.cancelAllButton);
        this.progressButtonsPanel.setVisible(false);
        JPanel progressPanel = new JPanel();
        progressPanel.setLayout(new BoxLayout(progressPanel, 1));
        progressPanel.setBorder(new EmptyBorder(6, 12, 10, 12));
        progressPanel.add(progressRow);
        progressPanel.add(Box.createVerticalStrut(6));
        progressPanel.add(this.progressButtonsPanel);
        JPanel bottomBar = new JPanel(new BorderLayout());
        bottomBar.add((Component)footer, "North");
        bottomBar.add((Component)progressPanel, "South");
        this.add((Component)bottomBar, "South");
        this.applyButton.addActionListener(e -> this.performBulkActions());
        this.updateStatusLabel();
    }

    private void bulkApply(SectionAction action) {
        int res;
        ArrayList<DiffEntry> targets = new ArrayList<DiffEntry>();
        for (DiffEntry e : this.allEntries()) {
            if (!e.selected || e.resolved || action == SectionAction.REVERT && e.type != SectionType.UPDATED || (action == SectionAction.DISABLE || action == SectionAction.ENABLE) && e.type == SectionType.REMOVED || action == SectionAction.REMOVE && e.type == SectionType.REMOVED) continue;
            targets.add(e);
        }
        if (targets.isEmpty()) {
            JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.files_remover.select_first_warning_body"), LanguageProvider.get((String)"gui.files_remover.select_first_warning_title"), 2);
            return;
        }
        if (action == SectionAction.REMOVE && (res = JOptionPane.showConfirmDialog(this, "You are going to remove " + targets.size() + " mod(s). Are you sure?", LanguageProvider.get((String)"gui.modlist_diff_dialog_name"), 0, 2)) != 0) {
            return;
        }
        this.setAllActionButtonsEnabled(false);
        ExecutorService executor = this.executorFor(action);
        executor.submit(() -> {
            Thread actionThread = null;
            if (!this.isInstantAction(action)) {
                this.activeActionThread = actionThread = Thread.currentThread();
            }
            try {
                this.clearInterruptFlag();
                for (DiffEntry entry : targets) {
                    this.clearInterruptFlag();
                    if (this.isCancelAllRequested()) break;
                    this.currentActionEntry = entry;
                    this.startAction(entry, action);
                    SwingUtilities.invokeLater(() -> this.refreshTables());
                    boolean success = this.performAction(entry, action);
                    this.finishAction(entry, action, success);
                    this.clearSingleCancelFor(entry);
                    this.currentActionEntry = null;
                    if (!this.isCancelAllRequested()) continue;
                    break;
                }
                SwingUtilities.invokeLater(() -> {
                    this.refreshTables();
                    this.setAllActionButtonsEnabled(true);
                    this.updateStatusLabel();
                    this.resetProgress();
                    this.clearCancelAllFlag();
                });
            }
            finally {
                if (actionThread != null && this.activeActionThread == actionThread) {
                    this.activeActionThread = null;
                }
                this.clearInterruptFlag();
            }
        });
    }

    void updateStatusLabel() {
        int added = this.countSelected(this.addedEntries);
        int updated = this.countSelected(this.updatedEntries);
        int removed = this.countSelected(this.removedEntries);
        String msg = LanguageProvider.get((String)"gui.modlist_diff.footer.counts").replace("$ADDED$", Integer.toString(added)).replace("$UPDATED$", Integer.toString(updated)).replace("$REMOVED$", Integer.toString(removed));
        this.statusLabel.setText(msg);
        this.statusLabel.setForeground(new Color(70, 70, 70));
        if (!this.cfReady && !this.mrReady) {
            this.statusLabel.setText(LanguageProvider.get((String)"gui.modlist_diff.fetching_warning"));
        }
        this.updateDisableToggleLabel();
        this.updateApplyButtonLabel();
    }

    private void copyDiffWithFeedback(final JButton button) {
        ClipboardUtils.copy(ModListDiff.getDiff((boolean)true).generateDiffMsg(true).toText());
        final String originalText = LanguageProvider.get((String)"gui.modlist_diff.copy_diff");
        button.setText(LanguageProvider.get((String)"gui.copied"));
        CrashAssistantGUI.highlightButton(button, new Color(100, 255, 100), 2600L);
        button.setEnabled(false);
        new Timer("copy-diff-feedback", true).schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> {
                    button.setText(originalText);
                    button.setEnabled(true);
                });
            }
        }, 2800L);
    }

    private int countSelected(List<DiffEntry> entries) {
        int c = 0;
        for (DiffEntry e : entries) {
            if (!e.selected || e.resolved) continue;
            ++c;
        }
        return c;
    }

    private void performBulkActions() {
        List<DiffEntry> toRemove = this.selectedOf(this.addedEntries);
        List<DiffEntry> toRevert = this.selectedOf(this.updatedEntries);
        List<DiffEntry> toRestore = this.selectedOf(this.removedEntries);
        if (toRemove.isEmpty() && toRevert.isEmpty() && toRestore.isEmpty()) {
            JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.files_remover.select_first_warning_body"), LanguageProvider.get((String)"gui.files_remover.select_first_warning_title"), 2);
            return;
        }
        String confirmMsg = LanguageProvider.get((String)"gui.modlist_diff.confirm.body").replace("$REMOVE$", Integer.toString(toRemove.size())).replace("$REVERT$", Integer.toString(toRevert.size())).replace("$DOWNLOAD$", Integer.toString(toRestore.size()));
        int res = JOptionPane.showConfirmDialog(this, confirmMsg, LanguageProvider.get((String)"gui.modlist_diff.confirm.title"), 0, 2);
        if (res != 0) {
            return;
        }
        this.cancelCurrentRequested = false;
        this.cancelAllRequested = false;
        this.cancelTargetEntry = null;
        this.setAllActionButtonsEnabled(false);
        ControlPanel.stopMovingToTop = true;
        for (DiffEntry entry : toRevert) {
            this.startAction(entry, SectionAction.REVERT);
        }
        for (DiffEntry entry : toRestore) {
            this.startAction(entry, SectionAction.RESTORE);
        }
        SwingUtilities.invokeLater(() -> {
            this.refreshTables();
            this.updateStatusLabel();
        });
        this.actionExecutor.submit(() -> {
            Thread actionThread;
            this.activeActionThread = actionThread = Thread.currentThread();
            try {
                boolean success;
                this.clearInterruptFlag();
                for (DiffEntry entry : toRemove) {
                    this.clearInterruptFlag();
                    if (this.isCancelAllRequested()) break;
                    this.currentActionEntry = entry;
                    this.performAction(entry, SectionAction.REMOVE);
                    this.currentActionEntry = null;
                }
                for (DiffEntry entry : toRevert) {
                    this.clearInterruptFlag();
                    if (this.isCancelAllRequested()) break;
                    this.currentActionEntry = entry;
                    success = this.performAction(entry, SectionAction.REVERT);
                    this.finishAction(entry, SectionAction.REVERT, success);
                    this.clearSingleCancelFor(entry);
                    this.currentActionEntry = null;
                    if (!this.isCancelAllRequested()) continue;
                    break;
                }
                for (DiffEntry entry : toRestore) {
                    this.clearInterruptFlag();
                    if (this.isCancelAllRequested()) break;
                    this.currentActionEntry = entry;
                    this.startAction(entry, SectionAction.RESTORE);
                    SwingUtilities.invokeLater(() -> {
                        this.refreshTables();
                        this.updateStatusLabel();
                    });
                    success = this.performAction(entry, SectionAction.RESTORE);
                    this.finishAction(entry, SectionAction.RESTORE, success);
                    this.clearSingleCancelFor(entry);
                    this.currentActionEntry = null;
                    if (!this.isCancelAllRequested()) continue;
                    break;
                }
                SwingUtilities.invokeLater(() -> {
                    this.refreshTables();
                    this.setAllActionButtonsEnabled(true);
                    this.updateStatusLabel();
                    this.resetProgress();
                    this.clearCancelAllFlag();
                });
            }
            finally {
                if (this.activeActionThread == actionThread) {
                    this.activeActionThread = null;
                }
                this.clearInterruptFlag();
            }
        });
    }

    private boolean isInstantAction(SectionAction action) {
        return action == SectionAction.DISABLE || action == SectionAction.ENABLE || action == SectionAction.REMOVE || action == SectionAction.SHOW_FOLDER;
    }

    private ExecutorService executorFor(SectionAction action) {
        return this.isInstantAction(action) ? this.instantActionExecutor : this.actionExecutor;
    }

    void runActionAsync(DiffEntry entry, SectionAction action) {
        ControlPanel.stopMovingToTop = true;
        this.clearInterruptFlag();
        this.cancelCurrentRequested = false;
        this.cancelTargetEntry = null;
        if (!this.isInstantAction(action)) {
            this.cancelCurrentRequested = false;
            this.cancelTargetEntry = null;
            this.currentActionEntry = entry;
        }
        this.startAction(entry, action);
        this.refreshTables();
        this.updateStatusLabel();
        this.executorFor(action).submit(() -> {
            Thread actionThread = null;
            if (!this.isInstantAction(action)) {
                this.activeActionThread = actionThread = Thread.currentThread();
            }
            try {
                this.clearInterruptFlag();
                boolean success = this.performAction(entry, action);
                SwingUtilities.invokeLater(() -> {
                    this.finishAction(entry, action, success);
                    this.refreshTables();
                    this.updateStatusLabel();
                    if (this.isCancelAllRequested()) {
                        this.resetProgress();
                    }
                    this.clearSingleCancelFor(entry);
                    if (!this.isInstantAction(action)) {
                        this.currentActionEntry = null;
                    }
                });
            }
            finally {
                if (actionThread != null && this.activeActionThread == actionThread) {
                    this.activeActionThread = null;
                }
                this.clearInterruptFlag();
            }
        });
    }

    private List<DiffEntry> selectedOf(List<DiffEntry> entries) {
        ArrayList<DiffEntry> list = new ArrayList<DiffEntry>();
        for (DiffEntry e : entries) {
            if (!e.selected || e.resolved) continue;
            list.add(e);
        }
        return list;
    }

    private void refreshTables() {
        for (SectionPanel panel : this.sectionPanels.values()) {
            panel.refresh();
        }
    }

    String versionLabel(Mod mod) {
        if (mod == null) {
            return "-";
        }
        String version = mod.getVersion();
        String name = mod.getJarName();
        if (version == null || version.isEmpty()) {
            return name;
        }
        if (mod.isModMessedUpWithVersion()) {
            return name + " (" + version + ")";
        }
        return version;
    }

    private void startAction(DiffEntry entry, SectionAction action) {
        if (action == SectionAction.REVERT) {
            entry.revertState = ActionState.RUNNING;
        }
        if (action == SectionAction.RESTORE) {
            entry.restoreState = ActionState.RUNNING;
        }
    }

    private void finishAction(DiffEntry entry, SectionAction action, boolean success) {
        if (action == SectionAction.REVERT) {
            ActionState actionState = entry.revertState = success ? ActionState.DONE : ActionState.IDLE;
        }
        if (action == SectionAction.RESTORE) {
            ActionState actionState = entry.restoreState = success ? ActionState.DONE : ActionState.IDLE;
        }
        if (success && (action == SectionAction.REVERT || action == SectionAction.REMOVE || action == SectionAction.RESTORE)) {
            entry.resolvedBy = action;
        }
    }

    private void requestCancelCurrentOperation() {
        this.cancelCurrentRequested = true;
        SwingUtilities.invokeLater(() -> {
            this.progressLabel.setText(LanguageProvider.get((String)"gui.modlist_diff.cancelling_current"));
            this.refreshTables();
        });
        this.instantActionExecutor.submit(() -> {
            this.abortRunningDownload(null);
            this.interruptActiveActionThread(null);
        });
    }

    private void requestCancelAllOperations() {
        this.cancelAllRequested = true;
        this.cancelCurrentRequested = true;
        this.cancelTargetEntry = null;
        SwingUtilities.invokeLater(() -> {
            this.cancelCurrentButton.setEnabled(false);
            this.cancelAllButton.setEnabled(false);
            this.progressLabel.setText(LanguageProvider.get((String)"gui.modlist_diff.cancelling_all"));
            this.refreshTables();
        });
        this.instantActionExecutor.submit(() -> {
            this.abortRunningDownload(null);
            this.interruptActiveActionThread(null);
            this.actionExecutor.getQueue().clear();
            SwingUtilities.invokeLater(() -> {
                this.resetQueuedRunningStatesAfterCancelAll();
                this.markEntryIdle(this.currentActionEntry);
                this.clearCancelFlagsIfIdle();
            });
        });
    }

    private boolean isCancelRequestedFor(DiffEntry entry) {
        if (this.cancelAllRequested) {
            return true;
        }
        return this.cancelCurrentRequested;
    }

    private boolean isCancelInProgressFor(DiffEntry entry) {
        if (this.cancelAllRequested) {
            return true;
        }
        return this.cancelCurrentRequested && (this.currentActionEntry == entry || this.activeDownloadEntry == entry);
    }

    private boolean isCancelAllRequested() {
        return this.cancelAllRequested;
    }

    private void rememberActiveDownload(DiffEntry entry, InputStream stream, HttpURLConnection connection) {
        this.activeDownloadEntry = entry;
        this.activeDownloadStream = stream;
        this.activeDownloadConnection = connection;
    }

    private void clearActiveDownload(InputStream stream) {
        if (this.activeDownloadStream == stream) {
            this.activeDownloadStream = null;
            this.activeDownloadEntry = null;
            this.activeDownloadConnection = null;
        }
    }

    private void abortRunningDownload(DiffEntry target) {
        InputStream stream = this.activeDownloadStream;
        HttpURLConnection connection = this.activeDownloadConnection;
        if (connection != null) {
            try {
                connection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stream == null) {
            if (connection != null && this.activeDownloadConnection == connection) {
                this.activeDownloadConnection = null;
                this.activeDownloadEntry = null;
            }
        } else if (this.activeDownloadStream == stream) {
            this.activeDownloadStream = null;
            this.activeDownloadEntry = null;
            this.activeDownloadConnection = null;
        }
    }

    private void interruptActiveActionThread(DiffEntry target) {
        Thread t = this.activeActionThread;
        if (t == null) {
            return;
        }
        try {
            t.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateProgress(String text, boolean indeterminate) {
        this.updateProgress(text, indeterminate, -1);
    }

    private void updateProgress(String text, boolean indeterminate, int percent) {
        SwingUtilities.invokeLater(() -> {
            this.progressLabel.setText(text);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(indeterminate);
            this.progressButtonsPanel.setVisible(true);
            this.cancelCurrentButton.setEnabled(true);
            this.cancelAllButton.setEnabled(true);
            if (!indeterminate && percent >= 0) {
                this.progressBar.setValue(percent);
            }
        });
    }

    private void resetProgress() {
        SwingUtilities.invokeLater(() -> {
            this.progressLabel.setText(" ");
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(0);
            this.progressButtonsPanel.setVisible(false);
            this.cancelCurrentButton.setEnabled(true);
            this.cancelAllButton.setEnabled(true);
            this.cancelCurrentRequested = false;
            this.cancelAllRequested = false;
            this.cancelTargetEntry = null;
            this.activeDownloadEntry = null;
            this.activeDownloadStream = null;
            this.activeDownloadConnection = null;
            this.statusLabel.setForeground(new Color(70, 70, 70));
        });
    }

    private void clearInterruptFlag() {
        if (Thread.interrupted()) {
            // empty if block
        }
    }

    private void clearCancelAllFlag() {
        this.cancelAllRequested = false;
    }

    private void consumeSingleCancel() {
        if (this.cancelCurrentRequested) {
            this.cancelCurrentRequested = false;
            this.cancelTargetEntry = null;
            this.resetProgress();
        }
    }

    private void clearSingleCancelFor(DiffEntry entry) {
        this.consumeSingleCancel();
    }

    private void clearCancelFlagsIfIdle() {
        if (this.actionExecutor.getActiveCount() == 0 && this.actionExecutor.getQueue().isEmpty()) {
            this.cancelAllRequested = false;
            this.cancelCurrentRequested = false;
            this.resetProgress();
        }
    }

    private void resetQueuedRunningStatesAfterCancelAll() {
        for (DiffEntry entry : this.allEntries()) {
            if (entry == this.currentActionEntry) continue;
            if (entry.revertState == ActionState.RUNNING) {
                entry.revertState = ActionState.IDLE;
            }
            if (entry.restoreState != ActionState.RUNNING) continue;
            entry.restoreState = ActionState.IDLE;
        }
    }

    private void markEntryIdle(DiffEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.revertState == ActionState.RUNNING) {
            entry.revertState = ActionState.IDLE;
        }
        if (entry.restoreState == ActionState.RUNNING) {
            entry.restoreState = ActionState.IDLE;
        }
    }

    private void addWarning(String text) {
        SwingUtilities.invokeLater(() -> {
            this.statusLabel.setText(text);
            this.statusLabel.setForeground(new Color(180, 60, 60));
        });
    }

    private void warnLookupNotReady() {
        if (this.lookupWarningShown) {
            return;
        }
        this.lookupWarningShown = true;
        this.addWarning(LanguageProvider.get((String)"gui.modlist_diff.wait_for_fetch"));
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.modlist_diff.wait_for_fetch"), LanguageProvider.get((String)"gui.modlist_diff_dialog_name"), 2));
    }

    private boolean isLookupReadyForEntry(DiffEntry entry) {
        boolean needsMr;
        boolean needsCf = !entry.getCurseHashes(true).isEmpty();
        boolean bl = needsMr = !entry.getModrinthHashes(true).isEmpty();
        if (!needsCf && !needsMr) {
            return true;
        }
        boolean cfOk = !needsCf || this.cfReady;
        boolean mrOk = !needsMr || this.mrReady;
        return cfOk || mrOk;
    }

    private boolean isConnectionIssue(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof IOException) {
            return true;
        }
        return this.isConnectionIssue(t.getCause());
    }

    private void setAllActionButtonsEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
        if (this.footerButtons != null) {
            for (JButton b : this.footerButtons) {
                b.setEnabled(enabled);
            }
        }
    }

    private boolean allSelectedDisabled() {
        boolean anySelected = false;
        for (DiffEntry e : this.allEntries()) {
            if (!e.selected || e.resolved || e.type == SectionType.REMOVED) continue;
            anySelected = true;
            if (this.isDisabledEntry(e)) continue;
            return false;
        }
        return anySelected;
    }

    boolean isDisabledEntry(DiffEntry entry) {
        return entry != null && entry.areAllCurrentDisabled();
    }

    private void updateDisableToggleLabel() {
        if (this.disableToggleButton == null) {
            return;
        }
        if (this.allSelectedDisabled()) {
            this.disableToggleButton.setText(LanguageProvider.get((String)"gui.files_remover.enable_selected"));
        } else {
            this.disableToggleButton.setText(LanguageProvider.get((String)"gui.files_remover.disable_selected"));
        }
    }

    private void updateApplyButtonLabel() {
        if (this.applyButton == null) {
            return;
        }
        String key = ModListDiff.isModpackCreator() ? "gui.modlist_diff.footer.apply" : "gui.modlist_diff.footer.apply.modpack";
        this.applyButton.setText(LanguageProvider.get((String)key));
    }

    private boolean performAction(DiffEntry entry, SectionAction action) {
        if (entry.modloaderEntry) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.modlist_diff.modloader_warning"), LanguageProvider.get((String)"gui.modlist_diff_dialog_name"), 2));
            this.addWarning(LanguageProvider.get((String)"gui.modlist_diff.modloader_warning"));
            return false;
        }
        if (!(action != SectionAction.REVERT && action != SectionAction.RESTORE || this.isLookupReadyForEntry(entry))) {
            this.warnLookupNotReady();
            return false;
        }
        switch (action) {
            case REMOVE: {
                return this.removeEntry(entry);
            }
            case DISABLE: {
                return this.toggleDisable(entry, true);
            }
            case ENABLE: {
                return this.toggleDisable(entry, false);
            }
            case REVERT: {
                return this.revertEntry(entry);
            }
            case RESTORE: {
                return this.restoreEntry(entry);
            }
            case SHOW_FOLDER: {
                this.openFolder(entry);
                return false;
            }
        }
        return false;
    }

    private boolean removeEntry(DiffEntry entry) {
        List<Path> targets = entry.currentPaths();
        if (targets.isEmpty()) {
            targets = entry.savedPaths();
        }
        if (targets.isEmpty()) {
            return false;
        }
        boolean ok = true;
        for (Path p : targets) {
            if (p == null) continue;
            try {
                Files.deleteIfExists(p);
            }
            catch (Exception e) {
                ok = false;
                CrashAssistantApp.LOGGER.error("Failed to remove {}", (Object)p, (Object)e);
            }
        }
        if (ok) {
            entry.resolved = true;
            entry.removedByAction = true;
            entry.resolvedBy = SectionAction.REMOVE;
        }
        return ok;
    }

    private boolean toggleDisable(DiffEntry entry, boolean disable) {
        List<DiffEntry.ModInstance> mods = entry.currentMods;
        if (mods.isEmpty()) {
            entry.resolved = true;
            return true;
        }
        try {
            for (DiffEntry.ModInstance mi : mods) {
                Path target;
                Path path = this.resolveExistingPath(mi.path, mi);
                if (path == null) continue;
                boolean currentlyDisabled = path.getFileName().toString().endsWith(".disabled");
                if (disable && currentlyDisabled || !disable && !currentlyDisabled) continue;
                if (currentlyDisabled) {
                    String newName = path.getFileName().toString().replaceFirst("\\.disabled$", "");
                    target = path.resolveSibling(newName);
                } else {
                    target = path.resolveSibling(path.getFileName().toString() + ".disabled");
                }
                Files.move(path, target, StandardCopyOption.REPLACE_EXISTING);
                mi.path = target;
            }
            return true;
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to toggle disable for {}", (Object)entry, (Object)e);
            return false;
        }
    }

    private Path resolveExistingPath(Path path, DiffEntry.ModInstance instance) {
        Path alt;
        if (path == null) {
            return null;
        }
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        String name = path.getFileName().toString();
        Path path2 = alt = name.endsWith(".disabled") ? path.resolveSibling(name.replaceFirst("\\.disabled$", "")) : path.resolveSibling(name + ".disabled");
        if (Files.exists(alt, new LinkOption[0])) {
            if (instance != null) {
                instance.path = alt;
            }
            return alt;
        }
        return null;
    }

    private boolean revertEntry(DiffEntry entry) {
        if (entry.savedMods.isEmpty()) {
            return false;
        }
        if (this.isCancelAllRequested()) {
            this.resetProgress();
            return false;
        }
        Path stagingDir = ModListUtils.MODS_FOLDER.resolve(".crash_assistant_tmp");
        ArrayList<DownloadResult> downloads = new ArrayList<DownloadResult>();
        HashSet<Path> keepFinalPaths = new HashSet<Path>();
        try {
            Files.createDirectories(stagingDir, new FileAttribute[0]);
            for (DiffEntry.ModInstance saved : entry.savedMods) {
                if (this.isCancelRequestedFor(entry)) {
                    this.consumeSingleCancel();
                    this.cleanupDownloads(downloads);
                    return false;
                }
                DownloadResult result = this.downloadSavedFile(entry, saved, stagingDir);
                if (result == null) {
                    this.consumeSingleCancel();
                    this.cleanupDownloads(downloads);
                    return false;
                }
                downloads.add(result);
                if (result.finalPath == null) continue;
                keepFinalPaths.add(result.finalPath.toAbsolutePath().normalize());
            }
            if (this.isCancelRequestedFor(entry)) {
                this.consumeSingleCancel();
                this.cleanupDownloads(downloads);
                return false;
            }
            if (!this.deletePaths(entry.currentPaths(), keepFinalPaths, entry)) {
                this.consumeSingleCancel();
                this.cleanupDownloads(downloads);
                return false;
            }
            if (this.isCancelRequestedFor(entry)) {
                this.consumeSingleCancel();
                this.cleanupDownloads(downloads);
                return false;
            }
            if (!this.placeDownloads(downloads, entry)) {
                this.consumeSingleCancel();
                this.cleanupDownloads(downloads);
                return false;
            }
            entry.resolved = true;
            entry.resolvedBy = SectionAction.REVERT;
            this.resetProgress();
            return true;
        }
        catch (Exception e) {
            if (!this.isCancelRequestedFor(entry)) {
                CrashAssistantApp.LOGGER.error("Failed to revert entry", (Throwable)e);
            }
            this.consumeSingleCancel();
            this.cleanupDownloads(downloads);
            this.resetProgress();
            return false;
        }
    }

    private boolean restoreEntry(DiffEntry entry) {
        if (entry.savedMods.isEmpty()) {
            return false;
        }
        if (this.isCancelAllRequested()) {
            this.resetProgress();
            return false;
        }
        Path stagingDir = ModListUtils.MODS_FOLDER.resolve(".crash_assistant_tmp");
        ArrayList<DownloadResult> downloads = new ArrayList<DownloadResult>();
        HashSet<Path> keepFinalPaths = new HashSet<Path>();
        try {
            Files.createDirectories(stagingDir, new FileAttribute[0]);
            for (DiffEntry.ModInstance saved : entry.savedMods) {
                DownloadResult result = this.downloadSavedFile(entry, saved, stagingDir);
                if (result == null) {
                    this.consumeSingleCancel();
                    this.cleanupDownloads(downloads);
                    return false;
                }
                downloads.add(result);
                if (result.finalPath == null) continue;
                keepFinalPaths.add(result.finalPath.toAbsolutePath().normalize());
            }
            if (this.isCancelRequestedFor(entry)) {
                this.consumeSingleCancel();
                this.cleanupDownloads(downloads);
                return false;
            }
            if (!this.placeDownloads(downloads, entry)) {
                this.consumeSingleCancel();
                this.cleanupDownloads(downloads);
                return false;
            }
            entry.resolved = true;
            this.resetProgress();
            return true;
        }
        catch (Exception e) {
            if (!this.isCancelRequestedFor(entry)) {
                CrashAssistantApp.LOGGER.error("Failed to restore entry", (Throwable)e);
            }
            this.consumeSingleCancel();
            this.cleanupDownloads(downloads);
            this.resetProgress();
            return false;
        }
    }

    private DownloadResult downloadSavedFile(DiffEntry entry, DiffEntry.ModInstance saved, Path stagingDir) throws Exception {
        String targetFileName;
        if (saved == null) {
            return null;
        }
        this.clearInterruptFlag();
        this.activeDownloadEntry = entry;
        this.activeDownloadConnection = null;
        this.activeDownloadStream = null;
        if (this.isCancelRequestedFor(entry)) {
            this.consumeSingleCancel();
            return null;
        }
        Files.createDirectories(stagingDir, new FileAttribute[0]);
        CurseForge.FingerprintMatch cf = saved.curseMatch;
        Modrinth.VersionFileInfo mr = saved.modrinthMatch;
        String string = targetFileName = saved.path != null && saved.path.getFileName() != null ? saved.path.getFileName().toString() : saved.fileName();
        if (cf != null && cf.fileName != null) {
            targetFileName = cf.fileName;
        } else if (mr != null && mr.fileName != null) {
            targetFileName = mr.fileName;
        }
        Path finalDir = saved.path != null && saved.path.getParent() != null ? saved.path.getParent() : ModListUtils.MODS_FOLDER;
        Path finalPath = finalDir.resolve(targetFileName);
        Path disabledPath = finalPath.resolveSibling(finalPath.getFileName().toString() + ".disabled");
        Path existing = this.findExistingMatching(saved, finalPath, disabledPath);
        if (existing != null) {
            if (existing.getFileName().toString().endsWith(".disabled")) {
                try {
                    Files.move(existing, finalPath, StandardCopyOption.REPLACE_EXISTING);
                    existing = finalPath;
                }
                catch (Exception e) {
                    CrashAssistantApp.LOGGER.error("Failed to rename disabled file {}", (Object)existing, (Object)e);
                }
            }
            return new DownloadResult(saved, null, targetFileName, existing, true);
        }
        String cfUrl = cf != null && cf.hasDownload() ? cf.downloadUrl : null;
        String mrUrl = mr != null && mr.downloadUrl != null ? mr.downloadUrl : null;
        Path stagedTarget = stagingDir.resolve(targetFileName);
        this.cleanupPartialDownload(stagedTarget);
        if (cfUrl == null && mrUrl == null) {
            if (cf != null) {
                CurseForge.SlugInfo slugInfo = CurseForge.resolveSlug(cf.modId);
                String slug = slugInfo != null ? slugInfo.slug : null;
                String pageUrl = slug == null ? null : "https://www.curseforge.com/minecraft/mc-mods/" + slug + "/files/" + cf.fileId;
                String expectedFileName = targetFileName;
                Path expectedDir = stagingDir;
                String expectedPageUrl = pageUrl;
                boolean[] ok = new boolean[]{false};
                CountDownLatch latch = new CountDownLatch(1);
                ManualDownloadDialog[] dialogRef = new ManualDownloadDialog[1];
                SwingUtilities.invokeLater(() -> {
                    ManualDownloadDialog dlg;
                    dialogRef[0] = dlg = new ManualDownloadDialog(this, expectedFileName, expectedDir, expectedPageUrl, this.buildHashSet(saved.curseHash), this.buildHashSet(saved.modrinthHash));
                    ok[0] = dlg.awaitResult();
                    latch.countDown();
                });
                try {
                    while (!latch.await(100L, TimeUnit.MILLISECONDS)) {
                        if (!this.isCancelRequestedFor(entry)) continue;
                        SwingUtilities.invokeLater(() -> {
                            if (dialogRef[0] != null) {
                                dialogRef[0].dispose();
                            }
                        });
                        this.cleanupPartialDownload(stagedTarget);
                        this.consumeSingleCancel();
                        return null;
                    }
                }
                catch (InterruptedException e) {
                    SwingUtilities.invokeLater(() -> {
                        if (dialogRef[0] != null) {
                            dialogRef[0].dispose();
                        }
                    });
                    this.cleanupPartialDownload(stagedTarget);
                    this.consumeSingleCancel();
                    return null;
                }
                if (ok[0]) {
                    return new DownloadResult(saved, stagedTarget, targetFileName, finalPath, false);
                }
                return null;
            }
            if (cf == null && mr == null && this.cfReady && this.mrReady) {
                String unavailableMsg = LanguageProvider.get((String)"gui.modlist_diff.unavailable_both").replace("$FILE$", targetFileName) + " " + LanguageProvider.get((String)"gui.modlist_diff.unavailable_legacy_hint");
                SwingUtilities.invokeLater(() -> {
                    JOptionPane.showMessageDialog(this, unavailableMsg, LanguageProvider.get((String)"gui.modlist_diff_dialog_name"), 2);
                    this.statusLabel.setText(LanguageProvider.get((String)"gui.modlist_diff.footer.counts").replace("$ADDED$", Integer.toString(this.countSelected(this.addedEntries))).replace("$UPDATED$", Integer.toString(this.countSelected(this.updatedEntries))).replace("$REMOVED$", Integer.toString(this.countSelected(this.removedEntries))));
                    this.statusLabel.setForeground(new Color(70, 70, 70));
                });
                return null;
            }
            this.addWarning(LanguageProvider.get((String)"gui.modlist_diff.wait_for_fetch"));
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.modlist_diff.wait_for_fetch"), LanguageProvider.get((String)"gui.modlist_diff_dialog_name"), 2));
            return null;
        }
        boolean tryCf = cfUrl != null;
        boolean tryMr = mrUrl != null;
        String firstUrl = null;
        String secondUrl = null;
        boolean firstIsMr = false;
        if (this.preferModrinth && tryMr) {
            firstUrl = mrUrl;
            firstIsMr = true;
            if (tryCf) {
                secondUrl = cfUrl;
            }
        } else if (tryCf) {
            firstUrl = cfUrl;
            firstIsMr = false;
            if (tryMr) {
                secondUrl = mrUrl;
            }
        } else {
            firstUrl = mrUrl;
            firstIsMr = true;
        }
        try {
            boolean success = this.performDownload(firstUrl, stagedTarget, entry, targetFileName);
            if (!success) {
                return null;
            }
            return new DownloadResult(saved, stagedTarget, targetFileName, finalPath, false);
        }
        catch (Exception e) {
            if (this.isCancelRequestedFor(entry)) {
                return null;
            }
            if (secondUrl != null && this.isConnectionIssue(e)) {
                CrashAssistantApp.LOGGER.warn("Failed to download from {}, trying fallback to {}. Error: {}", (Object)(firstIsMr ? "Modrinth" : "CurseForge"), (Object)(firstIsMr ? "CurseForge" : "Modrinth"), (Object)e.toString());
                this.cleanupPartialDownload(stagedTarget);
                try {
                    boolean success;
                    if (!firstIsMr) {
                        this.preferModrinth = true;
                    }
                    if (!(success = this.performDownload(secondUrl, stagedTarget, entry, targetFileName))) {
                        return null;
                    }
                    return new DownloadResult(saved, stagedTarget, targetFileName, finalPath, false);
                }
                catch (Exception ex) {
                    if (this.isCancelRequestedFor(entry)) {
                        return null;
                    }
                    throw ex;
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performDownload(String downloadUrl, Path stagedTarget, DiffEntry entry, String targetFileName) throws Exception {
        block32: {
            AtomicReference connectionException;
            AtomicReference rawInRef;
            HttpURLConnection httpConn;
            URLConnection conn;
            block31: {
                this.updateProgress(LanguageProvider.get((String)"gui.modlist_diff.downloading").replace("$FILE$", targetFileName), true);
                URL url = new URL(downloadUrl);
                conn = url.openConnection();
                HttpURLConnection httpURLConnection = httpConn = conn instanceof HttpURLConnection ? (HttpURLConnection)conn : null;
                if (httpConn != null) {
                    httpConn.setConnectTimeout(15000);
                    httpConn.setReadTimeout(15000);
                    this.activeDownloadConnection = httpConn;
                }
                if (this.isCancelRequestedFor(entry) || Thread.currentThread().isInterrupted()) {
                    this.abortRunningDownload(entry);
                    this.consumeSingleCancel();
                    return false;
                }
                rawInRef = new AtomicReference();
                connectionException = new AtomicReference();
                CountDownLatch connectionLatch = new CountDownLatch(1);
                Thread connectorThread = new Thread(() -> {
                    try {
                        rawInRef.set(conn.getInputStream());
                    }
                    catch (Exception e) {
                        connectionException.set(e);
                    }
                    finally {
                        connectionLatch.countDown();
                    }
                }, "modlist-downloader-connector");
                connectorThread.setDaemon(true);
                connectorThread.start();
                do {
                    try {
                        if (!connectionLatch.await(100L, TimeUnit.MILLISECONDS)) continue;
                        break block31;
                    }
                    catch (InterruptedException e) {
                        connectorThread.interrupt();
                        this.abortRunningDownload(entry);
                        this.consumeSingleCancel();
                        return false;
                    }
                } while (!this.isCancelRequestedFor(entry));
                connectorThread.interrupt();
                this.abortRunningDownload(entry);
                this.consumeSingleCancel();
                return false;
            }
            if (connectionException.get() != null) {
                if (this.isCancelRequestedFor(entry)) {
                    this.abortRunningDownload(entry);
                    this.consumeSingleCancel();
                    return false;
                }
                throw (Exception)connectionException.get();
            }
            InputStream rawIn = (InputStream)rawInRef.get();
            if (rawIn == null) {
                this.abortRunningDownload(entry);
                return false;
            }
            this.rememberActiveDownload(entry, rawIn, httpConn);
            if (this.isCancelRequestedFor(entry)) {
                this.abortRunningDownload(entry);
                this.consumeSingleCancel();
                return false;
            }
            int contentLength = conn.getContentLength();
            try {
                boolean bl;
                InputStream in = rawIn;
                OutputStream out = Files.newOutputStream(stagedTarget, new OpenOption[0]);
                byte[] buf = new byte[8192];
                long total = 0L;
                while (true) {
                    if (Thread.currentThread().isInterrupted() || this.isCancelRequestedFor(entry)) {
                        this.cleanupPartialDownload(stagedTarget);
                        this.consumeSingleCancel();
                        bl = false;
                        return bl;
                    }
                    int read = in.read(buf);
                    if (read == -1) break;
                    out.write(buf, 0, read);
                    total += (long)read;
                    if (contentLength <= 0) continue;
                    int percent = (int)(total * 100L / (long)contentLength);
                    this.updateProgress(LanguageProvider.get((String)"gui.modlist_diff.downloading").replace("$FILE$", targetFileName) + " " + percent + "%", false, percent);
                }
                if (!this.isCancelRequestedFor(entry)) break block32;
                this.cleanupPartialDownload(stagedTarget);
                this.consumeSingleCancel();
                bl = false;
                return bl;
                {
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            finally {
                this.clearActiveDownload(rawIn);
            }
        }
        return true;
    }

    private Path findExistingMatching(DiffEntry.ModInstance saved, Path finalPath, Path disabledPath) {
        try {
            if (Files.exists(finalPath, new LinkOption[0]) && this.fingerprintMatches(saved, finalPath)) {
                return finalPath;
            }
            if (Files.exists(disabledPath, new LinkOption[0]) && this.fingerprintMatches(saved, disabledPath)) {
                return disabledPath;
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to check existing file fingerprint for {}", (Object)finalPath, (Object)e);
        }
        return null;
    }

    private boolean fingerprintMatches(DiffEntry.ModInstance saved, Path candidate) {
        try {
            ModFingerprinter.IdentificationResult fp = ModFingerprinter.identify((Path)candidate);
            boolean cfOk = saved.curseHash != null && saved.curseHash.equals(fp.getCurseForgeHash());
            boolean mrOk = saved.modrinthHash != null && saved.modrinthHash.equals(fp.getModrinthHash());
            return cfOk || mrOk;
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to fingerprint candidate {}", (Object)candidate, (Object)e);
            return false;
        }
    }

    private boolean placeDownloads(List<DownloadResult> downloads, DiffEntry entry) throws Exception {
        for (DownloadResult dl : downloads) {
            if (this.isCancelRequestedFor(entry)) {
                this.consumeSingleCancel();
                return false;
            }
            if (dl == null) continue;
            if (dl.alreadyPresent) {
                if (dl.finalPath == null) continue;
                dl.source.path = dl.finalPath;
                continue;
            }
            if (dl.stagedPath == null) continue;
            Path finalTarget = dl.finalPath != null ? dl.finalPath : dl.stagedPath;
            Files.createDirectories(finalTarget.getParent(), new FileAttribute[0]);
            Files.move(dl.stagedPath, finalTarget, StandardCopyOption.REPLACE_EXISTING);
            dl.source.path = finalTarget;
        }
        return true;
    }

    private void cleanupDownloads(List<DownloadResult> downloads) {
        for (DownloadResult dl : downloads) {
            if (dl == null || dl.stagedPath == null) continue;
            this.cleanupPartialDownload(dl.stagedPath);
        }
    }

    private boolean deletePaths(List<Path> paths, Set<Path> keep, DiffEntry entry) {
        HashSet<Path> normalizedKeep = new HashSet<Path>();
        for (Path k : keep) {
            if (k == null) continue;
            normalizedKeep.add(k.toAbsolutePath().normalize());
        }
        for (Path p : paths) {
            Path np;
            if (this.isCancelRequestedFor(entry)) {
                this.consumeSingleCancel();
                return false;
            }
            if (p == null || normalizedKeep.contains(np = p.toAbsolutePath().normalize())) continue;
            try {
                Files.deleteIfExists(p);
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.error("Failed to delete {}", (Object)p, (Object)e);
            }
        }
        return true;
    }

    private void cleanupPartialDownload(Path target) {
        try {
            Files.deleteIfExists(target);
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.warn("Failed to delete partial download {}", (Object)target, (Object)e);
        }
    }

    private HashSet<Long> buildHashSet(Long value) {
        HashSet<Long> set = new HashSet<Long>();
        if (value != null) {
            set.add(value);
        }
        return set;
    }

    private HashSet<String> buildHashSet(String value) {
        HashSet<String> set = new HashSet<String>();
        if (value != null) {
            set.add(value);
        }
        return set;
    }

    private void openFolder(DiffEntry entry) {
        Path p = null;
        List<Path> current = entry.currentPaths();
        if (!current.isEmpty()) {
            p = current.get(0);
        } else {
            List<Path> saved = entry.savedPaths();
            if (!saved.isEmpty()) {
                p = saved.get(0);
            }
        }
        if (p == null) {
            return;
        }
        try {
            if (!Files.exists(p, new LinkOption[0])) {
                return;
            }
            String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            if (os.contains("win")) {
                new ProcessBuilder("explorer.exe", "/select,", p.toAbsolutePath().toString()).start();
            } else if (os.contains("mac")) {
                new ProcessBuilder("open", "-R", p.toAbsolutePath().toString()).start();
            } else {
                Path dir;
                Path path = dir = Files.isDirectory(p, new LinkOption[0]) ? p : p.getParent();
                if (dir != null) {
                    new ProcessBuilder("xdg-open", dir.toAbsolutePath().toString()).start();
                }
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to reveal {}", (Object)p, (Object)e);
        }
    }

    void openCurseForgeProject(DiffEntry entry) {
        CurseForge.FingerprintMatch match;
        DiffEntry.ModInstance mi = entry.anyCurseMatchInstance();
        CurseForge.FingerprintMatch fingerprintMatch = match = mi != null ? mi.curseMatch : null;
        if (match == null) {
            return;
        }
        try {
            Object url = null;
            CurseForge.SlugInfo slugInfo = CurseForge.resolveSlug(match.modId);
            if (slugInfo != null) {
                if (slugInfo.websiteUrl != null && !slugInfo.websiteUrl.isEmpty()) {
                    url = slugInfo.websiteUrl;
                } else if (slugInfo.slug != null && !slugInfo.slug.isEmpty()) {
                    url = "https://www.curseforge.com/minecraft/mc-mods/" + slugInfo.slug;
                }
            }
            if (url == null) {
                url = "https://www.curseforge.com/minecraft/mc-mods/" + match.modId;
            }
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI((String)url));
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to open CurseForge project", (Throwable)e);
        }
    }

    void openModrinthProject(DiffEntry entry) {
        Modrinth.VersionFileInfo info;
        DiffEntry.ModInstance mi = entry.anyModrinthMatchInstance();
        Modrinth.VersionFileInfo versionFileInfo = info = mi != null ? mi.modrinthMatch : null;
        if (info == null || info.projectUrl == null) {
            return;
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(info.projectUrl));
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to open Modrinth project", (Throwable)e);
        }
    }

    private static ImageIcon loadIcon(String resourcePath) {
        try {
            URL url = ModListDiffDialog.class.getResource(resourcePath);
            if (url == null) {
                return null;
            }
            return new ImageIcon(url);
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to load icon {}", (Object)resourcePath, (Object)e);
            return null;
        }
    }

    ImageIcon getCfIcon() {
        return CF_ICON;
    }

    ImageIcon getMrIcon() {
        return MR_ICON;
    }

    boolean isCfReady() {
        return this.cfReady;
    }

    boolean isMrReady() {
        return this.mrReady;
    }

    boolean isEntryActive(DiffEntry entry) {
        if (entry == null) {
            return false;
        }
        if (entry.resolved) {
            return false;
        }
        if (this.cancelAllRequested || this.isCancelInProgressFor(entry)) {
            return false;
        }
        return entry.revertState != ActionState.RUNNING && entry.restoreState != ActionState.RUNNING;
    }

    boolean isActionEnabled(DiffEntry entry, SectionAction action) {
        if (entry == null || action == null) {
            return false;
        }
        if (this.cancelAllRequested || this.isCancelInProgressFor(entry)) {
            return false;
        }
        if (!this.isEntryActive(entry)) {
            return false;
        }
        if (action == SectionAction.REVERT) {
            return entry.revertState == ActionState.IDLE;
        }
        if (action == SectionAction.RESTORE) {
            return entry.restoreState == ActionState.IDLE;
        }
        return true;
    }

    String getRowEnableLabel() {
        String label = LanguageProvider.get((String)"gui.files_remover.enable_selected");
        int space = label.indexOf(32);
        if (space > 0) {
            label = label.substring(0, space);
        }
        return label;
    }

    String getActionLabel(DiffEntry entry, SectionAction action, String defaultLabel) {
        if (entry.resolved && entry.resolvedBy != null && action != entry.resolvedBy) {
            return "";
        }
        switch (action) {
            case REVERT: {
                if (entry.revertState == ActionState.RUNNING) {
                    return LanguageProvider.get((String)"gui.modlist_diff.actions.reverting");
                }
                if (entry.revertState != ActionState.DONE) break;
                return LanguageProvider.get((String)"gui.modlist_diff.actions.reverted");
            }
            case RESTORE: {
                if (entry.restoreState == ActionState.RUNNING) {
                    return LanguageProvider.get((String)"gui.modlist_diff.actions.restoring");
                }
                if (entry.restoreState != ActionState.DONE) break;
                return LanguageProvider.get((String)"gui.modlist_diff.actions.restored");
            }
            case DISABLE: {
                if (!this.isDisabledEntry(entry)) break;
                return this.getRowEnableLabel();
            }
            case REMOVE: {
                if (entry.resolved && entry.resolvedBy != null && entry.resolvedBy != SectionAction.REMOVE) {
                    return "";
                }
                if (!entry.removedByAction) break;
                return LanguageProvider.get((String)"gui.modlist_diff.section.removed");
            }
            case SHOW_FOLDER: {
                return LanguageProvider.get((String)"gui.show");
            }
        }
        return defaultLabel;
    }

    JPanel wrapTop(JComponent comp) {
        JPanel wrapper = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMaximumSize() {
                Dimension d = this.getPreferredSize();
                return new Dimension(Integer.MAX_VALUE, d.height);
            }
        };
        wrapper.add((Component)comp, "North");
        wrapper.setOpaque(false);
        wrapper.setAlignmentX(0.0f);
        wrapper.setAlignmentY(0.0f);
        return wrapper;
    }

    private Dimension calculateMinSize() {
        int maxTableWidth = 0;
        for (SectionPanel sp : this.sectionPanels.values()) {
            maxTableWidth = Math.max(maxTableWidth, sp.getComponent().getPreferredSize().width);
        }
        int scrollbar = 32;
        int padding = 100;
        int minWidth = Math.max(maxTableWidth + scrollbar + padding, 600);
        return new Dimension(minWidth, 300);
    }

    int measureHeaderWidth(String text) {
        JLabel lbl = new JLabel(text);
        FontMetrics fm = lbl.getFontMetrics(lbl.getFont());
        return fm.stringWidth(text) + 24;
    }

    static {
        CF_ICON = ModListDiffDialog.loadIcon("/assets/cf_logo.png");
        MR_ICON = ModListDiffDialog.loadIcon("/assets/mr_logo.png");
    }

    static enum SectionType {
        ADDED,
        UPDATED,
        REMOVED;

    }

    static enum SectionAction {
        REMOVE,
        DISABLE,
        REVERT,
        RESTORE,
        ENABLE,
        SHOW_FOLDER;

    }

    static enum ActionState {
        IDLE,
        RUNNING,
        DONE;

    }

    private static class DownloadResult {
        final DiffEntry.ModInstance source;
        final Path stagedPath;
        final String finalFileName;
        final Path finalPath;
        final boolean alreadyPresent;

        DownloadResult(DiffEntry.ModInstance source, Path stagedPath, String finalFileName, Path finalPath, boolean alreadyPresent) {
            this.source = source;
            this.stagedPath = stagedPath;
            this.finalFileName = finalFileName;
            this.finalPath = finalPath;
            this.alreadyPresent = alreadyPresent;
        }
    }
}

